package mole.entities.characters 
{
	import mole.CSoundAssets;
	import mole.entities.controlers.CPlayerControler;
	import mole.entities.controlers.IControler;
	import mole.entities.CPlayer;
	import mole.entities.particles.CParticleEmitter;
	import mole.Main;
	
	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CMole extends CPlayer
	{
		/**
		 * Constructeur par défaut.
		 * @param	_PosX Position sur l'axe des X.
		 * @param	_PosY Position sur l'axe des Y.
		 * @param 	_IdMole
		 */
		public function CMole(_PosX:Number, _PosY:Number, _Controler:IControler, _IdMole:int, _iColor:int, _iNb:int) 
		{
			super(_PosX, _PosY, _Controler, _IdMole, _iColor, _iNb);
			
			type = "player";
			layer = 2;
		}
		
		/**
		 * Chargement du perso.
		 * @param	_Character
		 */
		override protected function Load(_Character:Class, _iColor:int):XML
		{
			var xml:XML = super.Load(_Character, _iColor);
			
			return xml;
		}
		
		/**
		 * 
		 */
		/**
		 * Callback de mise à jours.
		 */
		override public function OnUpdate():void
		{	
			if (collide("perforator", x, y))
			{
				CParticleEmitter.GenerateParticlesAtPoint(x, y, 3, 2, 3, 2, -1, -1, 1, 1, 180, 200, 0);
				Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.DEAD_SCIE]);
				OnDead();
				return;
			}
		}
		
		/**
		 * Callback lorsque le persnnage meurt.
		 */
		override public function OnDead():void
		{
			Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.DEAD_FEEDBACK]);
			Main.SoundManager.PlayRandomSound(CSoundAssets.s_RandomContainers[CSoundAssets.DEAD]);
			
			// On tente le respawn.
			Main.GameRules.RemovePlayer(this);
			Main.World.remove(this);
		}
	}
}